/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.jobs;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.sonarlint.eclipse.core.configurator.ProjectConfigurationRequest;
import org.sonarlint.eclipse.core.configurator.ProjectConfigurator;
import org.sonarlint.eclipse.core.internal.PreferencesUtils;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.configurator.ConfiguratorUtils;
import org.sonarlint.eclipse.core.internal.jobs.AbstractSonarProjectJob;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectRequest;
import org.sonarlint.eclipse.core.internal.jobs.StandaloneSonarLintClientFacade;
import org.sonarlint.eclipse.core.internal.markers.MarkerUtils;
import org.sonarlint.eclipse.core.internal.markers.SonarMarker;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProject;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProperty;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.ServersManager;
import org.sonarlint.eclipse.core.internal.tracking.Input;
import org.sonarlint.eclipse.core.internal.tracking.Trackable;
import org.sonarlint.eclipse.core.internal.tracking.Tracker;
import org.sonarlint.eclipse.core.internal.tracking.Tracking;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;
import org.sonarsource.sonarlint.core.client.api.common.analysis.Issue;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;

public class AnalyzeProjectJob
extends AbstractSonarProjectJob {
    private List<SonarLintProperty> extraProps;
    private final AnalyzeProjectRequest request;
    static final ISchedulingRule SONAR_ANALYSIS_RULE = ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();

    public AnalyzeProjectJob(AnalyzeProjectRequest request) {
        super(AnalyzeProjectJob.jobTitle(request), SonarLintProject.getInstance((IResource)request.getProject()));
        this.request = request;
        this.extraProps = PreferencesUtils.getExtraPropertiesForLocalAnalysis(request.getProject());
    }

    private static String jobTitle(AnalyzeProjectRequest request) {
        if (request.getFiles() == null) {
            return "SonarLint analysis of project " + request.getProject().getName();
        }
        if (request.getFiles().size() == 1) {
            return "SonarLint analysis of file " + request.getFiles().iterator().next().getProjectRelativePath().toString() + " (Project " + request.getProject().getName() + ")";
        }
        return "SonarLint analysis of project " + request.getProject().getName() + " (" + request.getFiles().size() + " files)";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected IStatus doRun(IProgressMonitor monitor) {
        block16: {
            tmpToDelete = new ArrayList<File>();
            try {
                try {
                    project = this.request.getProject();
                    sonarProject = SonarLintProject.getInstance((IResource)project);
                    projectSpecificWorkDir = project.getWorkingLocation("org.sonarlint.eclipse.core");
                    mergedExtraProps = new LinkedHashMap<String, String>();
                    filesToAnalyze = new ArrayList<IFile>(this.request.getFiles().size());
                    usedConfigurators = this.populateFilesToAnalyze(monitor, tmpToDelete, project, mergedExtraProps, filesToAnalyze);
                    inputFiles = this.buildInputFiles(filesToAnalyze);
                    for (SonarLintProperty sonarProperty : this.extraProps) {
                        mergedExtraProps.put(sonarProperty.getName(), sonarProperty.getValue());
                    }
                    if (!inputFiles.isEmpty()) {
                        this.runAnalysisAndUpdateMarkers(monitor, project, sonarProject, projectSpecificWorkDir, mergedExtraProps, inputFiles);
                    }
                    AnalyzeProjectJob.analysisCompleted(usedConfigurators, mergedExtraProps, monitor);
                    break block16;
                }
                catch (Exception e) {
                    SonarLintCorePlugin.getDefault().error("Error during execution of SonarLint analysis", e);
                    var13_13 = new Status(2, "org.sonarlint.eclipse.core", "Error when executing SonarLint analysis", (Throwable)e);
                    ** for (f : tmpToDelete)
                }
            }
            catch (Throwable var12_23) {
                ** for (f : tmpToDelete)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    f.delete();
                }
                catch (Exception e) {
                    SonarLintCorePlugin.getDefault().error("Unable to delete temporary file", e);
                }
                continue;
            }
lbl30:
            // 1 sources

            return var13_13;
lbl-1000:
            // 1 sources

            {
                try {
                    f.delete();
                }
                catch (Exception e) {
                    SonarLintCorePlugin.getDefault().error("Unable to delete temporary file", e);
                }
                continue;
            }
lbl40:
            // 1 sources

            throw var12_23;
        }
        for (File f : tmpToDelete) {
            try {
                f.delete();
            }
            catch (Exception e) {
                SonarLintCorePlugin.getDefault().error("Unable to delete temporary file", e);
            }
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void runAnalysisAndUpdateMarkers(IProgressMonitor monitor, IProject project, SonarLintProject sonarProject, IPath projectSpecificWorkDir, Map<String, String> mergedExtraProps, List<ClientInputFile> inputFiles) throws CoreException {
        Object config = sonarProject.isBound() ? new ConnectedAnalysisConfiguration(StringUtils.trimToNull(sonarProject.getModuleKey()), project.getLocation().toFile().toPath(), projectSpecificWorkDir.toFile().toPath(), inputFiles, mergedExtraProps) : new StandaloneAnalysisConfiguration(project.getLocation().toFile().toPath(), projectSpecificWorkDir.toFile().toPath(), inputFiles, mergedExtraProps);
        Map<IResource, List<Issue>> issuesPerResource = this.run((StandaloneAnalysisConfiguration)config, sonarProject, monitor);
        this.updateMarkers(issuesPerResource);
    }

    private List<ClientInputFile> buildInputFiles(List<IFile> filesToAnalyze) {
        ArrayList<ClientInputFile> inputFiles = new ArrayList<ClientInputFile>(filesToAnalyze.size());
        String allTestPattern = PreferencesUtils.getTestFileRegexps();
        String[] testPatterns = allTestPattern.split(",");
        List<PathMatcher> pathMatchersForTests = AnalyzeProjectJob.createMatchersForTests(testPatterns);
        for (IFile file : filesToAnalyze) {
            Path filePath = file.getRawLocation().makeAbsolute().toFile().toPath();
            inputFiles.add(new EclipseInputFile(pathMatchersForTests, file, filePath));
        }
        return inputFiles;
    }

    private Collection<ProjectConfigurator> populateFilesToAnalyze(IProgressMonitor monitor, Collection<File> tmpToDelete, IProject project, Map<String, String> mergedExtraProps, List<IFile> filesToAnalyze) {
        filesToAnalyze.addAll(this.request.getFiles());
        Collection<ProjectConfigurator> usedConfigurators = AnalyzeProjectJob.configure(project, filesToAnalyze, mergedExtraProps, monitor);
        AnalyzeProjectJob.handleLinkedFiles(tmpToDelete, filesToAnalyze);
        return usedConfigurators;
    }

    private static List<PathMatcher> createMatchersForTests(String[] testPatterns) {
        ArrayList<PathMatcher> pathMatchersForTests = new ArrayList<PathMatcher>();
        FileSystem fs = FileSystems.getDefault();
        String[] stringArray = testPatterns;
        int n = testPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String testPattern = stringArray[n2];
            pathMatchersForTests.add(fs.getPathMatcher("glob:" + testPattern));
            ++n2;
        }
        return pathMatchersForTests;
    }

    private static Collection<ProjectConfigurator> configure(IProject project, Collection<IFile> filesToAnalyze, Map<String, String> extraProperties, IProgressMonitor monitor) {
        ProjectConfigurationRequest configuratorRequest = new ProjectConfigurationRequest(project, filesToAnalyze, extraProperties);
        Collection<ProjectConfigurator> configurators = ConfiguratorUtils.getConfigurators();
        ArrayList<ProjectConfigurator> usedConfigurators = new ArrayList<ProjectConfigurator>();
        for (ProjectConfigurator configurator : configurators) {
            if (!configurator.canConfigure(project)) continue;
            configurator.configure(configuratorRequest, monitor);
            usedConfigurators.add(configurator);
        }
        return usedConfigurators;
    }

    private void updateMarkers(Map<IResource, List<Issue>> issuesPerResource) throws CoreException {
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        if (iTextFileBufferManager == null) {
            return;
        }
        PreviousMarkerCache markerCache = new PreviousMarkerCache(this.request);
        for (Map.Entry<IResource, List<Issue>> resourceEntry : issuesPerResource.entrySet()) {
            IResource r = resourceEntry.getKey();
            try {
                List<IMarker> previousMarkers = markerCache.getPrevious(r);
                List<Issue> rawIssues = resourceEntry.getValue();
                if (r instanceof IFile) {
                    this.issueTrackingOnFile(iTextFileBufferManager, r, previousMarkers, rawIssues);
                    continue;
                }
                AnalyzeProjectJob.issueTracking(r, previousMarkers, rawIssues, null);
            }
            catch (Exception e) {
                SonarLintCorePlugin.getDefault().error("Unable to compute position of SonarLint marker on resource " + r.getName(), e);
            }
        }
        markerCache.deleteUnmatched();
    }

    private void issueTrackingOnFile(ITextFileBufferManager iTextFileBufferManager, IResource r, List<IMarker> previousMarkers, List<Issue> rawIssues) throws CoreException, BadLocationException {
        IFile iFile = (IFile)r;
        try {
            iTextFileBufferManager.connect(iFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            ITextFileBuffer iTextFileBuffer = iTextFileBufferManager.getTextFileBuffer(iFile.getFullPath(), LocationKind.IFILE);
            IDocument iDoc = iTextFileBuffer.getDocument();
            AnalyzeProjectJob.issueTracking(r, previousMarkers, rawIssues, iDoc);
        }
        catch (Throwable throwable) {
            try {
                iTextFileBufferManager.disconnect(iFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
            throw throwable;
        }
        try {
            iTextFileBufferManager.disconnect(iFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    private static void issueTracking(IResource r, List<IMarker> previousMarkers, List<Issue> rawIssues, IDocument iDoc) throws BadLocationException, CoreException {
        Input<TrackableMarker> baseInput = AnalyzeProjectJob.prepareBaseInput(previousMarkers);
        Input<TrackableIssue> rawInput = AnalyzeProjectJob.prepareRawInput(iDoc, rawIssues);
        Tracking<TrackableIssue, TrackableMarker> tracking = new Tracker<TrackableIssue, TrackableMarker>().track(rawInput, baseInput);
        for (Map.Entry<TrackableIssue, TrackableMarker> entry : tracking.getMatchedRaws().entrySet()) {
            Issue issue = entry.getKey().getWrapped();
            IMarker marker = entry.getValue().getWrapped();
            previousMarkers.remove(marker);
            SonarMarker.updateAttributes(marker, issue, iDoc);
        }
        for (TrackableIssue newIssue : tracking.getUnmatchedRaws()) {
            SonarMarker.create(iDoc, r, newIssue.getWrapped());
        }
    }

    private static void analysisCompleted(Collection<ProjectConfigurator> usedConfigurators, Map<String, String> properties, IProgressMonitor monitor) {
        for (ProjectConfigurator p : usedConfigurators) {
            p.analysisComplete(Collections.unmodifiableMap(properties), monitor);
        }
    }

    private static void handleLinkedFiles(Collection<File> tmpToDelete, List<IFile> filesToAnalyze) {
        for (IFile file : filesToAnalyze) {
            if (!file.isLinked()) continue;
            File tmp = new File(file.getProject().getLocation().makeAbsolute().toFile(), file.getProjectRelativePath().toString());
            SonarLintCorePlugin.getDefault().debug(String.valueOf(file.getName()) + " is a linked resource. Will create a temporary copy");
            try {
                Files.copy(file.getContents(), tmp.toPath(), new CopyOption[0]);
                tmpToDelete.add(tmp);
            }
            catch (IOException | CoreException e) {
                SonarLintCorePlugin.getDefault().error("Unable to create temporary copy for linked resource", e);
            }
        }
    }

    public Map<IResource, List<Issue>> run(final StandaloneAnalysisConfiguration config, final SonarLintProject project, IProgressMonitor monitor) {
        SonarLintCorePlugin.getDefault().debug("Start analysis with configuration:\n" + config.toString());
        Thread.UncaughtExceptionHandler h = AnalyzeProjectJob.exceptionHandler();
        final HashMap<IResource, List<Issue>> issuesPerResource = new HashMap<IResource, List<Issue>>();
        Thread t = new Thread("SonarLint analysis"){

            @Override
            public void run() {
                if (StringUtils.isNotBlank(project.getServerId())) {
                    IServer server = ServersManager.getInstance().getServer(project.getServerId());
                    if (server == null) {
                        throw new IllegalStateException("Project '" + project.getProject().getName() + "' is linked to an unknow server: '" + project.getServerId() + "'. Please bind project again.");
                    }
                    server.startAnalysis((ConnectedAnalysisConfiguration)config, new SonarLintIssueListener(issuesPerResource));
                } else {
                    StandaloneSonarLintClientFacade facadeToUse = SonarLintCorePlugin.getDefault().getDefaultSonarLintClientFacade();
                    facadeToUse.startAnalysis(config, new SonarLintIssueListener(issuesPerResource));
                }
            }
        };
        t.setDaemon(true);
        t.setUncaughtExceptionHandler(h);
        t.start();
        AnalyzeProjectJob.waitForThread(monitor, t);
        return issuesPerResource;
    }

    private static void waitForThread(IProgressMonitor monitor, Thread t) {
        while (t.isAlive()) {
            if (monitor.isCanceled()) {
                t.interrupt();
                try {
                    t.join(5000L);
                }
                catch (InterruptedException interruptedException) {}
                if (!t.isAlive()) break;
                SonarLintCorePlugin.getDefault().error("Unable to properly terminate SonarLint analysis");
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static Thread.UncaughtExceptionHandler exceptionHandler() {
        return new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                SonarLintCorePlugin.getDefault().error("Error during analysis", ex);
            }
        };
    }

    private static Input<TrackableMarker> prepareBaseInput(List<IMarker> previous) {
        final List<TrackableMarker> wrapped = AnalyzeProjectJob.wrap(previous);
        return new Input<TrackableMarker>(){

            @Override
            public Collection<TrackableMarker> getIssues() {
                return wrapped;
            }
        };
    }

    private static List<TrackableMarker> wrap(List<IMarker> previous) {
        ArrayList<TrackableMarker> wrapped = new ArrayList<TrackableMarker>();
        for (IMarker marker : previous) {
            wrapped.add(new TrackableMarker(marker));
        }
        return wrapped;
    }

    private static Input<TrackableIssue> prepareRawInput(IDocument iDoc, List<Issue> issues) throws BadLocationException {
        final List<TrackableIssue> wrapped = AnalyzeProjectJob.wrap(iDoc, issues);
        return new Input<TrackableIssue>(){

            @Override
            public Collection<TrackableIssue> getIssues() {
                return wrapped;
            }
        };
    }

    private static List<TrackableIssue> wrap(IDocument iDoc, List<Issue> issues) throws BadLocationException {
        ArrayList<TrackableIssue> wrapped = new ArrayList<TrackableIssue>();
        for (Issue issue : issues) {
            Integer checksum = iDoc != null ? AnalyzeProjectJob.computeChecksum(iDoc, issue) : null;
            wrapped.add(new TrackableIssue(issue, checksum));
        }
        return wrapped;
    }

    private static Integer computeChecksum(IDocument iDoc, Issue issue) throws BadLocationException {
        Integer checksum;
        Integer startLine = issue.getStartLine();
        if (startLine == null) {
            checksum = null;
        } else {
            SonarMarker.Range rangeInFile = SonarMarker.findRangeInFile(issue, iDoc);
            checksum = SonarMarker.checksum(rangeInFile.getContent());
        }
        return checksum;
    }

    private final class EclipseInputFile
    implements ClientInputFile {
        private final List<PathMatcher> pathMatchersForTests;
        private final IFile file;
        private final Path filePath;

        private EclipseInputFile(List<PathMatcher> pathMatchersForTests, IFile file, Path filePath) {
            this.pathMatchersForTests = pathMatchersForTests;
            this.file = file;
            this.filePath = filePath;
        }

        public Path getPath() {
            return this.filePath;
        }

        public boolean isTest() {
            for (PathMatcher matcher : this.pathMatchersForTests) {
                if (!matcher.matches(this.filePath)) continue;
                return true;
            }
            return false;
        }

        public Charset getCharset() {
            try {
                return Charset.forName(this.file.getCharset());
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        public <G> G getClientObject() {
            return (G)this.file;
        }
    }

    private static class PreviousMarkerCache {
        Map<IResource, List<IMarker>> markersByResource = new HashMap<IResource, List<IMarker>>();

        public PreviousMarkerCache(AnalyzeProjectRequest request) {
            if (request.getFiles() != null) {
                for (IFile file : request.getFiles()) {
                    this.markersByResource.put((IResource)file, new ArrayList<IMarker>(MarkerUtils.findMarkers((IResource)file)));
                }
            } else {
                for (IMarker m : MarkerUtils.findMarkers((IResource)request.getProject())) {
                    if (!this.markersByResource.containsKey(m.getResource())) {
                        this.markersByResource.put(m.getResource(), new ArrayList());
                    }
                    this.markersByResource.get(m.getResource()).add(m);
                }
            }
        }

        public void deleteUnmatched() throws CoreException {
            for (List<IMarker> entry : this.markersByResource.values()) {
                for (IMarker m : entry) {
                    m.delete();
                }
            }
        }

        public List<IMarker> getPrevious(IResource r) {
            return this.markersByResource.containsKey(r) ? this.markersByResource.get(r) : Collections.emptyList();
        }
    }

    private final class SonarLintIssueListener
    implements IssueListener {
        private final Map<IResource, List<Issue>> issuesPerResource;

        private SonarLintIssueListener(Map<IResource, List<Issue>> issuesPerResource) {
            this.issuesPerResource = issuesPerResource;
        }

        public void handle(Issue issue) {
            ClientInputFile inputFile = issue.getInputFile();
            Object r = inputFile == null ? AnalyzeProjectJob.this.request.getProject() : (IResource)inputFile.getClientObject();
            if (!this.issuesPerResource.containsKey(r)) {
                this.issuesPerResource.put((IResource)r, new ArrayList());
            }
            this.issuesPerResource.get(r).add(issue);
        }
    }

    private static class TrackableIssue
    implements Trackable {
        private final Issue issue;
        private final Integer lineHash;

        public TrackableIssue(Issue issue, Integer lineHash) {
            this.issue = issue;
            this.lineHash = lineHash;
        }

        public Issue getWrapped() {
            return this.issue;
        }

        @Override
        public Integer getLine() {
            return this.issue.getStartLine();
        }

        @Override
        public String getMessage() {
            return SonarMarker.getMessage(this.issue);
        }

        @Override
        public Integer getLineHash() {
            return this.lineHash;
        }

        @Override
        public String getRuleKey() {
            return this.issue.getRuleKey();
        }
    }

    private static class TrackableMarker
    implements Trackable {
        private final IMarker marker;

        public TrackableMarker(IMarker marker) {
            this.marker = marker;
        }

        public IMarker getWrapped() {
            return this.marker;
        }

        @Override
        public Integer getLine() {
            int line = this.marker.getAttribute("lineNumber", 0);
            return line != 0 ? Integer.valueOf(line) : null;
        }

        @Override
        public String getMessage() {
            return this.marker.getAttribute("message", "");
        }

        @Override
        public Integer getLineHash() {
            int attribute = this.marker.getAttribute("checksum", 0);
            return attribute != 0 ? Integer.valueOf(attribute) : null;
        }

        @Override
        public String getRuleKey() {
            return this.marker.getAttribute("rulekey", "");
        }
    }
}

